/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRMod;
import lotr.common.quest.IPickpocketable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class LOTRItemCoin
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] coinIcons;
    public static int[] values = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};

    public LOTRItemCoin() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(LOTRCreativeTabs.tabMaterials);
    }

    private static int getSingleItemValue(ItemStack itemstack, boolean allowStolen) {
        if (itemstack != null && itemstack.func_77973_b() instanceof LOTRItemCoin) {
            if (!allowStolen && IPickpocketable.Helper.isPickpocketed(itemstack)) {
                return 0;
            }
            int i = itemstack.func_77960_j();
            if (i >= values.length) {
                i = 0;
            }
            return values[i];
        }
        return 0;
    }

    public static int getStackValue(ItemStack itemstack, boolean allowStolen) {
        if (itemstack == null) {
            return 0;
        }
        return LOTRItemCoin.getSingleItemValue(itemstack, allowStolen) * itemstack.field_77994_a;
    }

    public static int getInventoryValue(EntityPlayer entityplayer, boolean allowStolen) {
        int coins = 0;
        for (ItemStack itemstack : entityplayer.field_71071_by.field_70462_a) {
            coins += LOTRItemCoin.getStackValue(itemstack, allowStolen);
        }
        return coins += LOTRItemCoin.getStackValue(entityplayer.field_71071_by.func_70445_o(), allowStolen);
    }

    public static int getContainerValue(IInventory inv, boolean allowStolen) {
        if (inv instanceof InventoryPlayer) {
            return LOTRItemCoin.getInventoryValue(((InventoryPlayer)inv).field_70458_d, allowStolen);
        }
        int coins = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            coins += LOTRItemCoin.getStackValue(itemstack, allowStolen);
        }
        return coins;
    }

    public static void takeCoins(int coins, EntityPlayer entityplayer) {
        ItemStack is;
        ItemStack itemstack;
        int slot;
        ItemStack coin;
        int value;
        int i;
        InventoryPlayer inv = entityplayer.field_71071_by;
        int invValue = LOTRItemCoin.getInventoryValue(entityplayer, false);
        if (invValue < coins) {
            FMLLog.warning((String)("Attempted to take " + coins + " coins from player " + entityplayer.func_70005_c_() + " who has only " + invValue), (Object[])new Object[0]);
        }
        int initCoins = coins;
        block0: for (i = values.length - 1; i >= 0; --i) {
            value = values[i];
            if (value > initCoins) continue;
            coin = new ItemStack(LOTRMod.silverCoin, 1, i);
            for (slot = -1; slot < inv.field_70462_a.length; ++slot) {
                while ((itemstack = slot == -1 ? inv.func_70445_o() : inv.field_70462_a[slot]) != null && itemstack.func_77969_a(coin)) {
                    if (slot == -1) {
                        is = inv.func_70445_o();
                        if (is != null) {
                            --is.field_77994_a;
                            if (is.field_77994_a <= 0) {
                                inv.func_70437_b(null);
                            }
                        }
                    } else {
                        inv.func_70298_a(slot, 1);
                    }
                    if ((coins -= value) < value) continue block0;
                }
            }
        }
        if (coins > 0) {
            for (i = 0; i < values.length; ++i) {
                if (i == 0) continue;
                value = values[i];
                coin = new ItemStack(LOTRMod.silverCoin, 1, i);
                block4: for (slot = -1; slot < inv.field_70462_a.length; ++slot) {
                    while ((itemstack = slot == -1 ? inv.func_70445_o() : inv.field_70462_a[slot]) != null && itemstack.func_77969_a(coin)) {
                        if (slot == -1) {
                            is = inv.func_70445_o();
                            if (is != null) {
                                --is.field_77994_a;
                                if (is.field_77994_a <= 0) {
                                    inv.func_70437_b(null);
                                }
                            }
                        } else {
                            inv.func_70298_a(slot, 1);
                        }
                        if ((coins -= value) < 0) break block4;
                    }
                }
                if (coins < 0) break;
            }
        }
        if (coins < 0) {
            LOTRItemCoin.giveCoins(-coins, entityplayer);
        }
    }

    public static void giveCoins(int coins, EntityPlayer entityplayer) {
        ItemStack coin;
        int value;
        int i;
        InventoryPlayer inv = entityplayer.field_71071_by;
        if (coins <= 0) {
            FMLLog.warning((String)("Attempted to give a non-positive value of coins " + coins + " to player " + entityplayer.func_70005_c_()), (Object[])new Object[0]);
        }
        for (i = values.length - 1; i >= 0; --i) {
            value = values[i];
            coin = new ItemStack(LOTRMod.silverCoin, 1, i);
            while (coins >= value && inv.func_70441_a(coin.func_77946_l())) {
                coins -= value;
            }
        }
        if (coins > 0) {
            for (i = values.length - 1; i >= 0; --i) {
                value = values[i];
                coin = new ItemStack(LOTRMod.silverCoin, 1, i);
                while (coins >= value) {
                    entityplayer.func_71019_a(coin.func_77946_l(), false);
                    coins -= value;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int i) {
        if (i >= this.coinIcons.length) {
            i = 0;
        }
        return this.coinIcons[i];
    }

    public String func_77667_c(ItemStack itemstack) {
        int i = itemstack.func_77960_j();
        if (i >= values.length) {
            i = 0;
        }
        return super.func_77658_a() + "." + values[i];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        this.coinIcons = new IIcon[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.coinIcons[i] = iconregister.func_94245_a(this.func_111208_A() + "_" + values[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean advanced) {
        int i = itemstack.func_77960_j();
        if (i >= values.length) {
            i = 0;
        }
        String localizedText = StatCollector.func_74838_a((String)"item.lotrCoin.number");
        list.add(EnumChatFormatting.GRAY + String.format(localizedText, EnumChatFormatting.YELLOW + String.valueOf(values[i]) + EnumChatFormatting.GRAY));
        int stackValue = LOTRItemCoin.getStackValue(itemstack, false);
        String stackValueText = StatCollector.func_74838_a((String)"item.lotrCoin.total");
        list.add(EnumChatFormatting.GRAY + String.format(stackValueText, EnumChatFormatting.GOLD + String.valueOf(stackValue) + EnumChatFormatting.GRAY));
    }

    public static int getMetaIndexForCost(int cost) {
        for (int i = values.length - 1; i >= 0; --i) {
            if (cost < values[i]) continue;
            return i;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int j = 0; j < values.length; ++j) {
            list.add(new ItemStack(item, 1, j));
        }
    }
}

